<?php

class EWRporta_Model_Settings extends XenForo_Model
{
	public function getSettings()
	{
		$options = $this->_getDb()->fetchAll("
			SELECT *
				FROM EWRporta_settings
		");

		$settings = array();
		foreach ($options AS $option)
		{
			$settings[$option['module_name']][$option['setting_name']] = $option['setting_value'];
			$option['setting_name'] = str_ireplace($option['module_name'].'_', '', $option['setting_name']);
			$settings[$option['module_name']][$option['setting_name']] = $option['setting_value'];
		}

		return $settings;
	}

	public function getSettingByName($setName)
	{
		if (!$setting = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_settings
			WHERE setting_name = ?
		", $setName))
		{
			return false;
		}

		return $setting;
	}

	public function getSettingsByModule($modName)
	{
		$settings = $this->_getDb()->fetchAll("
			SELECT *
				FROM EWRporta_settings
			WHERE module_name = ?
			ORDER BY setting_desc
		", $modName);

		foreach ($settings AS &$setting)
		{
			switch ($setting['setting_format'])
			{
				case 'forums':		$setting['HTML'] = $this->buildForumChooser($setting);	break;
				case 'check':		$setting['HTML'] = $this->buildCheckBox($setting);		break;
				case 'textarea':	$setting['HTML'] = $this->buildTextArea($setting);		break;
				default:			$setting['HTML'] = $this->buildStringBox($setting);		break;
			}
		}

		return $settings;
	}

	public function updateSettings($input)
	{
		foreach ($input['settings'] AS $key => $setting)
		{
			$setting['value'] = is_array($setting['value']) ? implode(',',$setting['value']) : $setting['value'];

			$this->_getDb()->query("
				UPDATE EWRporta_settings
				SET setting_value = ?
				WHERE setting_name = ?
			", array($setting['value'], $key));
		}

		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Modules');
		$dw->setExistingData($input);
		$dw->set('module_cache', $input['module_cache']);
		$dw->set('module_show', implode(',',$input['module_show']));
		$dw->set('module_hide', implode(',',$input['module_hide']));
		$dw->set('module_locked', $input['module_locked']);
		$dw->save();

		$this->getModelFromCache('EWRporta_Model_Cache')->emptyModuleCache($input);

		return true;
	}

	public function buildStringBox($setting)
	{
		return '<input type="text" name="settings['.$setting['setting_name'].'][value]" class="textCtrl" value="'.$setting['setting_value'].'" style="width: 300px;" />';
	}

	public function buildTextArea($setting)
	{
		return '<textarea name="settings['.$setting['setting_name'].'][value]" class="textCtrl" rows="10" style="width: 400px;">'.$setting['setting_value'].'</textarea>';
	}

	public function buildCheckBox($setting)
	{
		$checked = $setting['setting_value'] ? ' checked' : '';
		return '<label for="'.$setting['setting_name'].'"><input type="hidden" name="settings['.$setting['setting_name'].'][value]" value="0">
			<input type="checkbox" name="settings['.$setting['setting_name'].'][value]" value="1" id="'.$setting['setting_name'].'"'.$checked.'> Enable</label>';
	}

	public function buildForumChooser($setting)
	{
		$forums = $this->getModelFromCache('XenForo_Model_Node')->getAllNodes();
		$forums = $this->getModelFromCache('XenForo_Model_Node')->getNodeOptionsArray($forums, 0, '(unspecified)');
		$select = explode(',',$setting['setting_value']);

		$html = '<select multiple name="settings['.$setting['setting_name'].'][value][]" class="textCtrl" size="10">';
		foreach ($forums AS $forum)
		{
			$prefix = $forum['depth'] ? str_repeat('&nbsp; &nbsp; ', $forum['depth']) : '';
			$selected = in_array($forum['value'], $select) ? ' selected' : '';
			$html .= '<option value="'.$forum['value'].'"'.$selected.'>'.$prefix.$forum['label'].'</option>';
		}
		$html .= '</select>';

		return $html;
	}
}